package race;

import java.util.ArrayList;
import java.util.Observable;

/**
 * This class incapsulates an {@link ArrayList} but provides a observable
 * behavior in addition to the whole set of method inherited from
 * {@link ArrayList}
 * 
 * @author simone
 *
 * @param <T>: the param of the {@link ArrayList} incapsulated
 */
public class ObservableList<T> extends Observable {

	private ArrayList<T> list;

	public void setList(ArrayList<T> list) {
		this.list = list;
		setChanged();
		notifyObservers();
	}

	public ArrayList<T> getList() {
		return list;
	}
}
